<style>
    .headlap {
        text-align: center;
    }

    .headlap h3 {
        font-weight: 900;
    }

    .headlap h5 {
        font-weight: 800;
        color: red;
    }

    table.lap {
        width: 100%;
        border: 1px solid;
    }

    .lap tr th {
        border: 1px solid;
        border-color: rgb(126, 124, 124);
        text-align: center;
        background-color: rgb(22, 128, 226);
        color: white;
    }

    .lap tr td {
        border: 1px solid;
        border-color: rgb(126, 124, 124);
        font-size: 15px;
        text-align: left;
        padding: 3px;
    }

    th.inf {
        background-color: rgb(180, 19, 19) !important;
    }

    @media print {

        @page {
            margin: 20px;
            size: auto;
        }

        .lap tr th {
            border: 1px solid;
            border-color: rgb(126, 124, 124);
            text-align: center;
            background-color: rgb(115, 115, 245);
            color: white;
            font-size: 10pt;
        }

        .lap tr td {
            border: 1px solid;
            border-color: rgb(126, 124, 124);
            font-size: 12px;
        }

        th.inf {
            background-color: rgb(180, 19, 19) !important;
        }
    }
</style>
<div class="headlap">
    <h3>LAPORAN DATA KEUANGAN <br>
        {{ $data['tgl1'] }} - {{ $data['tgl2'] }}
    </h3>
    <div style="border:1px solid; margin: 10px"></div>
    <div class="row">
        <div class="col-md-4">
            <table class="lap">
                <thead>
                    <tr>
                        <th class="inf" colspan="5">DATA PENDAPATAN</th>
                    </tr>
                    <tr>
                        <th>No</th>
                        <th>Tanggal</th>
                        <th>Cash</th>
                        <th>Transfer</th>
                        <th>Ongkir</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $ttlpk = [];
                        $ttlpt = [];
                        $onk = [];
                    @endphp
                    @forelse ($penjualan as $k)
                        @php
                            $ttlpk[] = $k->jmlk;
                            $ttlpt[] = $k->jmlt;
                            $onk[] = $k->ok;
                        @endphp
                        <tr>
                            <td class="text-center">{{ $no++ }}</td>
                            <td>{{ date('d/m/Y', strtotime($k->tgl)) }}</td>
                            <td class="text-right">{{ number_format($k->jmlk, 0, ',', '.') }},-</td>
                            <td class="text-right">{{ number_format($k->jmlt, 0, ',', '.') }},-</td>
                            <td class="text-right">{{ number_format($k->ok, 0, ',', '.') }},-</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center">Data tidak di temukan</td>
                        </tr>
                    @endforelse
                @empty(!array_sum($ttlpk))
                    <tr style="background-color: rgb(241, 211, 211) !important; font-weight: bold !important ">
                        <td colspan="2" class="text-center">Total</td>
                        <td class="text-right">{{ number_format(array_sum($ttlpk), 0, ',', '.') }},-</td>
                        <td class="text-right">{{ number_format(array_sum($ttlpt), 0, ',', '.') }},-</td>
                        <td class="text-right">{{ number_format(array_sum($onk), 0, ',', '.') }},-</td>
                    </tr>
                @endempty
            </tbody>
        </table>
    </div>
    <div class="col-md-4">
        <table class="lap">
            <thead>
                <tr>
                    <th class="inf" colspan="3">DATA PENGELUARAN</th>
                </tr>
                <tr>
                    <th>No</th>
                    <th>Tanggal</th>
                    <th>Jumlah</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $i = 1;
                    $ttlp = [];
                @endphp
                @forelse ($pengeluaran as $p)
                    @php
                        $ttlp[] = $p->jml;
                    @endphp
                    <tr>
                        <td class="text-center">{{ $i++ }}</td>
                        <td>{{ date('d/m/Y', strtotime($p->tgl)) }}</td>
                        <td class="text-right">{{ number_format($p->jml, 0, ',', '.') }},-</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="3" class="text-center">Data tidak di temukan</td>
                    </tr>
                @endforelse
            @empty(!array_sum($ttlp))
                <tr style="background-color: rgb(241, 211, 211) !important; font-weight: bold !important ">
                    <td colspan="2" class="text-center">Total</td>
                    <td class="text-right">
                        {{ number_format(array_sum($ttlp), 0, ',', '.') }},-
                    </td>
                </tr>
            @endempty
        </tbody>
    </table>
</div>
<div class="col-md-4">
    <table class="lap mb-3">
        <thead>
            <tr>
                <th style="background-color: rgb(6, 104, 79) !important">TOTAL PENDAPATAN</th>
            </tr>
            <tr>
                <td style="font-weight: bold; font-size: 25px">Rp.
                @empty(!array_sum($ttlpk))
                    <span style="float: right; ">
                        {{ number_format(array_sum($ttlpk) + array_sum($ttlpt) + array_sum($onk), 0, ',', '.') }},-
                    </span>
                @else
                    <span style="float: right;">0,-</span>
                @endempty
            </td>
        </tr>
    </thead>
</table>

<table class="lap mb-3">
    <thead>
        <tr>
            <th style="background-color: rgb(6, 104, 79) !important">TOTAL PENGELUARAN</th>
        </tr>
        <tr>
            <td style="font-weight: bold; font-size: 25px">Rp.
            @empty(!array_sum($ttlp))
                <span style="float: right; ">
                    {{ number_format(array_sum($ttlp), 0, ',', '.') }},-
                </span>
            @else
                <span style="float: right;">0,-</span>
            @endempty
        </td>
    </tr>
</thead>
</table>

<table class="lap mb-3">
<thead>
    <tr>
        <th style="background-color: rgb(rgb(8, 119, 50)portant">PROFIT</th>
    </tr>
    <tr>
        <td style="font-weight: bold; font-size: 25px">Rp.
            @php
                if (!empty(array_sum($ttlpk))) {
                    $ttl = array_sum($ttlpk) + array_sum($ttlpt) + array_sum($onk);
                } else {
                    $ttl = 0;
                }

                if (!empty(array_sum($ttlp))) {
                    $pgl = array_sum($ttlp);
                } else {
                    $pgl = 0;
                }
            @endphp
            <span style="float: right; ">
                {{ number_format($ttl - $pgl, 0, ',', '.') }},-
            </span>
        </td>
    </tr>
</thead>
</table>
</div>

</div>
